/*
 * Decompiled with CFR 0.152.
 */
package org.embeddedt.embeddium.api;

import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import me.jellysquid.mods.sodium.client.render.chunk.compile.pipeline.BlockRenderContext;
import net.minecraft.util.RandomSource;

public class BlockRendererRegistry {
    private static final BlockRendererRegistry instance = new BlockRendererRegistry();
    private final List<RenderPopulator> renderPopulators = new CopyOnWriteArrayList<RenderPopulator>();

    private BlockRendererRegistry() {
    }

    public static BlockRendererRegistry instance() {
        return instance;
    }

    public void registerRenderPopulator(RenderPopulator populator) {
        this.renderPopulators.add(populator);
    }

    public void fillCustomRenderers(List<Renderer> resultList, BlockRenderContext context) {
        if (this.renderPopulators.isEmpty()) {
            return;
        }
        for (RenderPopulator populator : this.renderPopulators) {
            populator.fillCustomRenderers(resultList, context);
        }
    }

    public static interface RenderPopulator {
        public void fillCustomRenderers(List<Renderer> var1, BlockRenderContext var2);

        public static RenderPopulator forRenderer(Renderer renderer) {
            return (resultList, ctx) -> resultList.add(renderer);
        }
    }

    public static interface Renderer {
        public RenderResult renderBlock(BlockRenderContext var1, RandomSource var2, VertexConsumer var3);
    }

    public static enum RenderResult {
        OVERRIDE,
        PASS;

    }
}

